package ru.yandex.chemodan.app.djfs.core.notification;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.Album;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;

/**
 * @author yashunsky
 */
public class XivaPushGeneratorAlbumUtils {
    public static XivaData albumRemoved(DjfsUid uid, Album album) {
        JsonObject parameters = JsonUtils.objectBuilder()
                .add("id", album.getId().toHexString())
                .add("type", "album_remove")
                .add("public_key", album.getPublicKey().getOrElse(""))
                .toJsonObject();
        return new XivaAlbumData(uid, parameters, JsonArray.empty());
    }

    public static XivaData albumsMerged(DjfsUid uid, Album srcAlbum, Album dstAlbum, Option<String> newTitle) {
        JsonUtils.JsonObjectBuilder parametersBuilder = JsonUtils.objectBuilder()
                .add("src_id", srcAlbum.getId().toHexString())
                .add("dst_id", dstAlbum.getId().toHexString())
                .add("type", "albums_merged");

        newTitle.ifPresent(title -> parametersBuilder.add("new_dst_title", title));

        return new XivaAlbumData(uid, parametersBuilder.toJsonObject(), JsonArray.empty());
    }

    private static class XivaAlbumData extends XivaData {
        public XivaAlbumData(DjfsUid uid, JsonObject parameters, JsonArray values) {
            super(uid, "albums", "album", parameters, values);
        }
    }
}
