package ru.yandex.chemodan.app.djfs.core.operations;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class OperationContextConfiguration {
    @Bean
    public PgOperationDao pgOperationDao(PgShardedDaoContext dependencies) {
        return new PgOperationDao(dependencies);
    }

    @Bean
    @Primary
    public OperationDao operationDaoProxy(DaoProxyFactory daoProxyFactory,
            PgOperationDao pgDao)
    {
        return daoProxyFactory.create(OperationDao.class, pgDao);
    }

    @Bean
    public MpfsOperationHandlerProperties mpfsOperationHandlerProperties() {
        return new MpfsOperationHandlerProperties();
    }
}
