package ru.yandex.chemodan.app.djfs.core.operations;

import java.util.UUID;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.bender.BenderParserSerializer;

/**
 * @author eoshch
 */
public interface OperationDao {
    @Sharded
    void insert(Operation operation);

    @Sharded
    Option<Operation> find(DjfsUid uid, String id);

    @Sharded
    ListF<Operation> find(DjfsUid uid, String type, String subtype);

    @Sharded
    long count(DjfsUid uid, ListF<Operation.State> states, ListF<String> notTypes);

    @Sharded
    long count(DjfsUid uid, Instant after);

    @Sharded
    boolean changeState(DjfsUid uid, String id, Operation.State from, Operation.State to);

    @Sharded
    boolean setDtime(DjfsUid uid, String id, Instant dtime);

    /**
     * Operation is only for mongo backwards compatibility. Remove when mongo is not used anymore.
     */
    @Sharded
    <T> void setData(DjfsUid uid, String id, T data, BenderParserSerializer<T> bender, Operation operation);

    @Sharded
    boolean tryAcquireOrRenewLockForExecution(DjfsUid uid, String id, UUID lockId, Duration lockExpiry);

    @Sharded
    void releaseLock(DjfsUid uid, String id, UUID lockId);
}
