package ru.yandex.chemodan.app.djfs.core.operations;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public class OperationNotFoundException extends DjfsException {
    public final DjfsUid uid;
    public final String oid;

    public OperationNotFoundException(DjfsUid uid, String oid) {
        super("operation " + oid + " for uid " + uid.asString() + " not found");
        this.uid = uid;
        this.oid = oid;
    }
}
