package ru.yandex.chemodan.app.djfs.core.overdraft;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoDao;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author friendlyevil
 */
@ActionContainer
@AllArgsConstructor
public class OverdraftActions {
    private final DiskInfoDao diskInfoDao;
    private final OverdraftDao overdraftDao;

    @Path(value = "/reset_overdraft_date", methods = HttpMethod.POST)
    public void resetOverdraftDate(@RequestParam("uid") String uid) {
        DjfsUid djfsUid = DjfsUid.cons(uid);
        overdraftDao.updateOverdraftDates(djfsUid);
        diskInfoDao.incrementResetOverdraftCounter(djfsUid);
    }
}
