package ru.yandex.chemodan.app.djfs.core.overdraft;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.djfs.core.db.pg.DjfsPgContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoDao;

/**
 * @author friendlyevil
 */
@Configuration
@Import({
        DjfsPgContextConfiguration.class,
        DiskInfoContextConfiguration.class,
})
public class OverdraftContextConfiguration {
    @Bean
    public OverdraftDao overdraftDao(PgShardedDaoContext pgShardedDaoContext) {
        return new OverdraftDao(pgShardedDaoContext);
    }

    @Bean
    public OverdraftActions overdraftActions(DiskInfoDao diskInfoDao, OverdraftDao overdraftDao) {
        return new OverdraftActions(diskInfoDao, overdraftDao);
    }
}
