package ru.yandex.chemodan.app.djfs.core.overdraft;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author friendlyevil
 */
public class OverdraftDao extends PgShardedDao {
    public OverdraftDao(PgShardedDaoContext context) {
        super(context);
    }

    public void updateOverdraftDates(DjfsUid uid) {
        String sql = collectStats(uid) +  "" +
                " update disk.overdraft as overdraft" +
                " set overdraft_date = now()::date, last_email_date = null, last_push_date = null " +
                " where overdraft.uid = :uid";

        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
