package ru.yandex.chemodan.app.djfs.core.publication;

import java.time.Instant;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Builder
@Value
public class LinkData implements DjfsUidSource {
    private final DjfsUid uid;

    private final String id;
    @Builder.Default
    private final Option<String> parentId = Option.empty();

    private final String linkDataPath;
    @Builder.Default
    private final Option<Long> version = Option.empty();
    @Builder.Default
    private final Option<String> userIp = Option.empty();
    @Builder.Default
    private final Option<DjfsUid> publicUid = Option.empty();
    @Builder.Default
    private final Option<DjfsUid> resourceIdUid = Option.empty();
    private final String type;

    @Builder.Default
    private final Option<Instant> dateCreated = Option.empty();
    @Builder.Default
    private final Option<Instant> dateModified = Option.empty();
    @Builder.Default
    private final Option<Instant> dateDeleted = Option.empty();

    @Builder.Default
    private final Option<DjfsResourceId> resourceId = Option.empty();
    @Builder.Default
    private final Option<DjfsResourcePath> targetPath = Option.empty();  // be careful, this field is used only for
    // compatibility reasons, it's not updated when parent folder moved using quick move

    @Builder.Default
    private final Option<DjfsFileId> fileId = Option.empty();
}
