package ru.yandex.chemodan.app.djfs.core.publication;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface LinkDataDao {
    @Sharded
    void deleteAll(DjfsUid uid);

    @Deprecated // use this function carefully, only if you know what you need it for. Path is not updated on quick move
    @Sharded
    ListF<LinkData> find(DjfsUid uid, ListF<DjfsResourcePath> targetPaths);

    @Sharded
    Option<LinkData> findBySymlink(DjfsUid uid, String path);

    /**
     * Use in tests only!
     * Not ready for production!
     *
     */
    @Sharded
    void insert(LinkData linkData);
}
