package ru.yandex.chemodan.app.djfs.core.publication;

import lombok.Value;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Bendable
@BenderBindAllFields
@Value
public class MongoBlockings {
    public static final MongoBenderParserSerializer<ObjectId, MongoBlockings> B =
            DjfsBenderFactory.createForMongo(MongoBlockings.class);

    @MongoId
    private final byte[] id;
    private final MapF<String, DateTime> simple;
    private final MapF<String, DateTime> video;
    private final MapF<String, DateTime> folder;
    private final Option<Boolean> pb;
}
