package ru.yandex.chemodan.app.djfs.core.publication;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.MongoCollectionX;

public class MongoBlockingsDao {

    private final MongoClient mongoClient;

    public MongoBlockingsDao(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    private MongoCollectionX<ObjectId, MongoBlockings> getCollection() {
        final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("uuuuMMdd");
        final String today = LocalDateTime.now().format(formatter);
        final String tomorrow = LocalDateTime.now().plusDays(1L).format(formatter);
        final String collectionName = "excess_" + today + "_0000_" + tomorrow + "_0000";
        final MongoCollection<BsonDocument> collection =
                mongoClient.getDatabase("download_stat").getCollection(collectionName, BsonDocument.class);
        return new MongoCollectionX<>(collection, MongoBlockings.B);
    }

    public Option<MongoBlockings> find(String hid) {
        BsonBinary binaryHid = new BsonBinary(BsonBinarySubType.OLD_BINARY, hid.getBytes());
        return getCollection().findOne(Filters.eq("_id", binaryHid), ReadPreference.secondaryPreferred());
    }

    public ListF<MongoBlockings> find(ListF<String> hids, ReadPreference readPreference) {
        ListF<BsonBinary> binaryhids = hids.map(hid -> new BsonBinary(BsonBinarySubType.OLD_BINARY, hid.getBytes()));
        return getCollection().find(Filters.in("_id", binaryhids), readPreference);
    }
}
