package ru.yandex.chemodan.app.djfs.core.publication;

import com.mongodb.client.model.Filters;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.exception.DjfsNotImplementedException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public class MongoLinkDataDao extends MongoShardedDao<String, MongoLinkData> implements LinkDataDao {
    public MongoLinkDataDao(MongoShardedDaoContext dependencies) {
        super(dependencies, "link_data", "link_data", MongoLinkData.B);
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        collectionX(uid).deleteMany(Filters.eq("uid", uid.asString()));
    }

    @Override
    public ListF<LinkData> find(DjfsUid uid, ListF<DjfsResourcePath> targetPaths) {
        throw new DjfsNotImplementedException();
    }

    @Override
    public Option<LinkData> findBySymlink(DjfsUid uid, String path) {
        throw new DjfsNotImplementedException();
    }

    @Override
    public void insert(LinkData linkData) {
        throw new DjfsNotImplementedException();
    }
}
