package ru.yandex.chemodan.app.djfs.core.publication;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.LegacyMpfsAes;
import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.MongoSupportDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.QuotaManager;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class PublicationContextConfiguration {
    @Bean
    public MongoLinkDataDao mongoLinkDataDao(MongoShardedDaoContext dependencies) {
        return new MongoLinkDataDao(dependencies);
    }

    @Bean
    public PgLinkDataDao pgLinkDataDao(PgShardedDaoContext dependencies) {
        return new PgLinkDataDao(dependencies);
    }

    @Bean
    @Primary
    public LinkDataDao linkDataDaoProxy(DaoProxyFactory daoProxyFactory, MongoLinkDataDao mongoDao,
            PgLinkDataDao pgDao)
    {
        return daoProxyFactory.create(LinkDataDao.class, pgDao);
    }

    @Bean
    @Qualifier("disableOverdraftPublicLink")
    public BleedingEdge disableOverdraftPublicLinkBleedingEdge() {
        return new BleedingEdge("disable-overdraft-public-links");
    }

    @Bean
    public PublicationManager publicationManager(LegacyMpfsAes legacyMpfsAes, LinkDataDao linkDataDao,
            Filesystem filesystem, Blackbox2 blackbox2, UserDao userDao,
            MongoSupportDao mongoSupportDao, BlockingsManager blockingsManager,
            @Qualifier("disableOverdraftPublicLink") BleedingEdge bleedingEdge) {
        return new PublicationManager(legacyMpfsAes, linkDataDao, filesystem, blackbox2, userDao,
                mongoSupportDao, blockingsManager, bleedingEdge);
    }

    @Bean
    LegacyMpfsAes legacyMpfsAes(@Value("${download-url-generator.aes-key}") String aesKey) {
        return new LegacyMpfsAes(aesKey);
    }

    @Bean
    public BlockingsManager blockingsManager(QuotaManager quotaManager, MongoBlockingsDao blockingsDao) {
        return new BlockingsManager(quotaManager, blockingsDao);
    }
}
