package ru.yandex.chemodan.app.djfs.core.share;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Value
@Builder
public class Group implements DjfsUidSource {
    private final String id;
    private final DjfsUid owner;
    private final DjfsResourcePath path;
    private final Option<Long> version;
    private final long size;

    @Override
    public DjfsUid getUid() {
        return owner;
    }
}
