package ru.yandex.chemodan.app.djfs.core.share;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public interface GroupDao {
    @Sharded
    void insert(Group group);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    ListF<Group> findAll(DjfsUid uid);

    @Sharded
    ListF<Group> findAll(ListF<String> groupIds);

    @Sharded
    Option<Group> find(String id);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    void increaseSize(String id, long delta);

    @Sharded
    void remove(String id);
}
