package ru.yandex.chemodan.app.djfs.core.share;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;

/**
 * @author eoshch
 */
@Value
@Builder
public class GroupLink implements DjfsUidSource {
    private final String id;
    private final String groupId;
    private final DjfsUid uid;
    private final DjfsResourcePath path;
    private final long version;
    private final SharePermissions permissions;
    private final Instant creationTime;

    @Builder.Default
    private final Option<String> b2bKey = Option.empty();

    @Builder.Default
    private final Option<String> universeService = Option.empty();

    @Builder.Default
    private final Option<String> universeLogin = Option.empty();

    public Option<Long> getSearchIndexerBaseVersion() {
        return Option.of(InstantUtils.toVersion(creationTime));
    }
}
