package ru.yandex.chemodan.app.djfs.core.share;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public interface GroupLinkDao {
    @Sharded
    void insert(GroupLink groupLink);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    ListF<GroupLink> findAll(DjfsUid uid);

    @Sharded
    Option<GroupLink> find(String id);

    @Sharded
    ListF<GroupLink> findByGroupId(String groupId);

    @Sharded
    void changePermissions(String groupLinkId, SharePermissions permissions);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    void delete(String id);
}
