package ru.yandex.chemodan.app.djfs.core.share;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoGroup extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoGroup> B =
            DjfsBenderFactory.createForMongo(MongoGroup.class);

    @MongoId
    public String id;
    public String owner;
    public String path;

    // В базе 172 записи без версий
    public Option<Long> v;
    public long size;

    public Group to() {
        return Group.builder()
                .id(id)
                .owner(DjfsUid.cons(owner))
                .path(DjfsResourcePath.cons(owner, path))
                .version(v)
                .size(size)
                .build();
    }

    public static MongoGroup cons(Group group) {
        MongoGroup result = new MongoGroup();
        result.id = group.getId();
        result.owner = group.getOwner().toString();
        result.path = group.getPath().getPath();
        result.v = group.getVersion();
        result.size = group.getSize();
        return result;
    }
}
