package ru.yandex.chemodan.app.djfs.core.share;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author m-messiah
 */
@BenderBindAllFields
public class MongoGroupInvite extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoGroupInvite> B =
            DjfsBenderFactory.createForMongo(MongoGroupInvite.class);

    @MongoId
    public String id;
    public Option<String> uid;

    public GroupInvite to() {
        return GroupInvite.builder()
                .id(id)
                .uid(uid.map(DjfsUid::cons))
                .build();
    }

    public static MongoGroupInvite cons(GroupInvite groupInvite) {
        MongoGroupInvite result = new MongoGroupInvite();
        result.id = groupInvite.getId();
        result.uid = groupInvite.getUid().map(DjfsUid::toString);
        return result;
    }
}
