package ru.yandex.chemodan.app.djfs.core.share;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyUserIsReadOnlyException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoGroupInviteDao implements GroupInviteDao {
    private final MongoCollectionX<String, MongoGroupInvite> collection;
    private final Function0<Boolean> isReadonly;

    public MongoGroupInviteDao(MongoClient mongoClient, Function0<Boolean> isReadonly) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("group_invites").getCollection("group_invites", BsonDocument.class),
                MongoGroupInvite.B);
        this.isReadonly = isReadonly;
    }

    public void deleteAll(DjfsUid uid) {
        if (isReadonly.apply()) {
            throw new LegacyUserIsReadOnlyException(new DjfsException("Mongo group_invites is in readonly"));
        }
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
