package ru.yandex.chemodan.app.djfs.core.share;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoGroupLink extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoGroupLink> B =
            DjfsBenderFactory.createForMongo(MongoGroupLink.class);

    @MongoId
    public String id;
    public String uid;
    public String gid;
    public String path;
    public long v;
    public int rights;

    public Option<Integer> ctime;

    @BenderPart(name = "b2b_key", strictName = true)
    public Option<String> b2bKey;

    @BenderPart(name = "universe_service", strictName = true)
    public Option<String> universeService;

    @BenderPart(name = "universe_login", strictName = true)
    public Option<String> universeLogin;

    public GroupLink to() {
        return GroupLink.builder()
                .id(id)
                .path(DjfsResourcePath.cons(uid, path))
                .groupId(gid)
                .uid(DjfsUid.cons(uid))
                .version(v)
                .permissions(SharePermissions.R.fromValue(rights))
                .creationTime(ctime.map(InstantUtils::fromSeconds).getOrElse(Instant.now()))
                .b2bKey(b2bKey)
                .universeLogin(universeLogin)
                .universeService(universeService)
                .build();
    }

    public static MongoGroupLink cons(GroupLink groupLink) {
        MongoGroupLink result = new MongoGroupLink();
        result.id = groupLink.getId();
        result.gid = groupLink.getGroupId();
        result.uid = groupLink.getUid().toString();
        result.path = groupLink.getPath().getPath();
        result.rights = groupLink.getPermissions().value();
        result.ctime = Option.of(InstantUtils.toSeconds(groupLink.getCreationTime()));
        result.b2bKey = groupLink.getB2bKey();
        result.universeLogin = groupLink.getUniverseLogin();
        result.universeService = groupLink.getUniverseService();
        result.v = groupLink.getVersion();
        return result;
    }
}
