package ru.yandex.chemodan.app.djfs.core.share;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.ResultSetUtils;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.misc.cache.tl.TlCache;

public class PgGroupInviteDao extends PgShardedDao implements GroupInviteDao {
    private final static RowMapper<GroupInvite> M = (rs, rowNum) -> GroupInvite.builder()
            .id(UuidUtils.toHexString(ResultSetUtils.getUuid(rs, "id")))
            .uid(ResultSetUtils.getLongO(rs, "uid").map(DjfsUid::cons))
            .build();

    public PgGroupInviteDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.group_invites WHERE uid = :uid";
        TlCache.flush();
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
