package ru.yandex.chemodan.app.djfs.core.share;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.EventManager;
import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.FilesystemAccessController;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author eoshch
 */
@Configuration
public class ShareContextConfiguration {
    private final DynamicProperty<Boolean> isGroupsInPG =
            new DynamicProperty<>("djfs.common.is-groups-in-pg", false);

    private final DynamicProperty<Boolean> isMongoGroupsInReadonly =
            new DynamicProperty<>("djfs.common.is-mongo-groups-in-readonly", false);

    @Bean
    public MongoGroupDao mongoGroupDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoGroupDao(mongoClient, isMongoGroupsInReadonly::get);
    }

    @Bean
    public PgGroupDao pgGroupDao(PgShardedDaoContext dependencies) {
        return new PgGroupDao(dependencies);
    }

    @Bean
    @Primary
    public GroupDao groupDaoProxy(DaoProxyFactory daoProxyFactory, MongoGroupDao mongoDao, PgGroupDao pgDao) {
        return daoProxyFactory.create(GroupDao.class, pgDao, mongoDao, isGroupsInPG::get);
    }

    @Bean
    public MongoGroupInviteDao mongoGroupInviteDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoGroupInviteDao(mongoClient, isMongoGroupsInReadonly::get);
    }

    @Bean
    public PgGroupInviteDao pgGroupInviteDao(PgShardedDaoContext dependencies) {
        return new PgGroupInviteDao(dependencies);
    }

    @Bean
    @Primary
    public GroupInviteDao groupInviteDaoProxy(DaoProxyFactory daoProxyFactory, MongoGroupInviteDao mongoDao, PgGroupInviteDao pgDao) {
        return daoProxyFactory.create(GroupInviteDao.class, pgDao, mongoDao, isGroupsInPG::get);
    }

    @Bean
    public MongoGroupLinkDao mongoGroupLinkDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoGroupLinkDao(mongoClient, isMongoGroupsInReadonly::get);
    }

    @Bean
    public PgGroupLinkDao pgGroupLinkDao(PgShardedDaoContext dependencies) {
        return new PgGroupLinkDao(dependencies);
    }

    @Bean
    @Primary
    public GroupLinkDao groupLinkDaoProxy(DaoProxyFactory daoProxyFactory, MongoGroupLinkDao mongoDao, PgGroupLinkDao pgDao) {
        return daoProxyFactory.create(GroupLinkDao.class, pgDao, mongoDao, isGroupsInPG::get);
    }

    @Bean
    public ShareInfoManager shareInfoManager(GroupDao groupDao, GroupLinkDao groupLinkDao) {
        return new ShareInfoManager(groupDao, groupLinkDao);
    }

    @Bean
    public ShareManager shareManager(GroupDao groupDao, GroupLinkDao groupLinkDao,
            DjfsResourceDao djfsResourceDao, UserDao userDao, ShareInfoManager shareInfoManager,
            FilesystemAccessController filesystemAccessController, EventManager eventManager)
    {
        return new ShareManager(groupDao, groupLinkDao, djfsResourceDao, userDao, shareInfoManager,
                filesystemAccessController, eventManager);
    }
}
