package ru.yandex.chemodan.app.djfs.core.share;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.FilesystemPermission;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author eoshch
 */
public enum SharePermissions implements IntEnum {
    READ(640),
    READ_WRITE(660),
    ;

    private final int value;

    SharePermissions(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean hasPermission(FilesystemPermission permission) {
        if (permission == FilesystemPermission.READ) {
            return true;
        }
        if (permission == FilesystemPermission.WRITE) {
            return this == READ_WRITE;
        }
        return false;
    }

    public static final IntEnumResolver<SharePermissions> R = IntEnumResolver.r(SharePermissions.class);
}
