package ru.yandex.chemodan.app.djfs.core.share.event;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.EventManager;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Value
@Builder
public class UserKickedFromGroupEvent implements EventManager.Event {
    private final Instant instant;
    private final DjfsUid uid;
    private final ShareInfo shareInfo;
    @Builder.Default
    private final Option<FolderDjfsResource> userShareRoot = Option.empty();
}
