package ru.yandex.chemodan.app.djfs.core.tasks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.SafeCloseable;
import ru.yandex.chemodan.app.djfs.core.util.ThreadLocalCacheUtil;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public abstract class DjfsCeleryOnetimeTask extends CeleryOnetimeTask {
    private static final Logger errorLogger = LoggerFactory.getLogger("error");

    protected abstract void handle(CeleryOnetimeTaskParameters parameters, ExecutionContext context);

    @Override
    protected final void execute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) {
        DjfsCeleryOnetimeTaskLogger.Status status = DjfsCeleryOnetimeTaskLogger.Status.FAIL;
        try (SafeCloseable ignored = ThreadLocalCacheUtil.withThreadLocalCache()) {
            try {
                handle(parameters, context);
                status = DjfsCeleryOnetimeTaskLogger.Status.OK;
            } catch (DelayDjfsCeleryOnetimeTaskException e) {
                // do not log exception as unhandled
                status = DjfsCeleryOnetimeTaskLogger.Status.DELAY;
                throw e;
            } catch (Exception e) {
                errorLogger.error("onetime task unhandled: ", e);
                throw e;
            } finally {
                DjfsCeleryOnetimeTaskLogger.log(status, parameters, context, Option.empty(), Option.empty());
            }
        }
    }
}
