package ru.yandex.chemodan.app.djfs.core.tasks;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.util.DurationUtils;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskContext;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public class DjfsCeleryOnetimeTaskLogger {
    // logger name is used by loggiver: rename/move class with caution
    private static final Logger logger = LoggerFactory.getLogger(DjfsCeleryOnetimeTaskLogger.class);

    public static void log(Status status, CeleryOnetimeTaskParameters parameters, ExecutionContext context,
            Option<Operation> operation, Option<Operation.State> operationState)
    {
        if (logger.isEnabledFor(Level.INFO)) {
            Instant finished = Instant.now();
            String sb = "Task " + context.getFullJobId().getJobId().getUuid().toString()
                    + " " + status
                    + " (try " + parameters.getContext().filterMap(CeleryOnetimeTaskContext::getCurrentTry)
                    .map(x -> Integer.toString(x)).getOrElse("-") + "),"
                    + " name: " + context.getFullJobId().getTaskId().getId()
                    + " (" + operation.map(Operation::getType).getOrElse("-")
                    + ", " + operation.map(Operation::getSubtype).getOrElse("-") + ")"
                    + " (processed: "
                    + DurationUtils.formatAsSecondsWithMillis(new Duration(context.getStart(), finished)) + " sec,"
                    + " lifetime: " + parameters.getContext().filterMap(CeleryOnetimeTaskContext::getCreated)
                    .map(x -> new Duration(x, finished)).map(DurationUtils::formatAsSecondsWithMillis)
                    .getOrElse("0.00") + " sec),"
                    + " task_status: " + status
                    + ", oper_state: " + operationState.map(x -> Integer.toString(x.value())).getOrElse("-")
                    + ", oper_title: " + operation.map(x -> x.getState().toString()).getOrElse("-")
                    + ", oper_id: " + operation.map(Operation::getId).getOrElse("-");
            logger.info(sb);
        }
    }

    public enum Status {
        FAIL,
        DELAY,
        OK,
    }
}
