package ru.yandex.chemodan.app.djfs.core.tasks;

import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public abstract class DjfsCronTask extends CronTask {
    private static final Logger errorLogger = LoggerFactory.getLogger("error");

    @Override
    public abstract Duration timeout();

    @Override
    public final void execute(ExecutionContext executionContext) throws Exception {
        try {
            execute();
        } catch (Exception e) {
            errorLogger.error("cron task unhandled: ", e);
            throw e;
        }
    }

    public abstract void execute() throws Exception;
}
