package ru.yandex.chemodan.app.djfs.core.tasks;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.djfs.core.db.pg.TransactionUtils;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.QuotaManager;
import ru.yandex.chemodan.app.djfs.core.filesystem.iteration.ResourceIterator;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.QuickMovePostProcessTask;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.QuickMovePostProcessTaskProperties;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.QuickMovePostProcessTaskSubmitter;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.TrashAreaPostProcessor;


@Configuration
public class DjfsTasksContextConfiguration {
    @Bean
    public QuickMovePostProcessTask quickMovePostProcessTask(ResourceIterator.Factory resourceIteratorFactory,
            Filesystem filesystem, DjfsResourceDao djfsResourceDao,
            QuickMovePostProcessTaskProperties quickMovePostProcessTaskProperties,
            QuotaManager quotaManager, TransactionUtils transactionUtils,
            QuickMovePostProcessTaskSubmitter quickMovePostProcessTaskSubmitter,
            TrashAreaPostProcessor trashAreaPostProcessor)
    {
        return new QuickMovePostProcessTask(quickMovePostProcessTaskProperties,
                resourceIteratorFactory, filesystem, djfsResourceDao, quotaManager, transactionUtils,
                quickMovePostProcessTaskSubmitter, trashAreaPostProcessor);
    }
}
