package ru.yandex.chemodan.app.djfs.core.user;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.ActionContext;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;

import static ru.yandex.chemodan.app.djfs.core.user.UserData.USER_OBJ;

/**
 * @author alexandret
 */
@RequiredArgsConstructor
public class CheckBlockedInterceptor implements ActionInvocationInterceptor {
    private final UserDao userDao;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        Option<CheckBlocked> checkBlockedAnnotationO =
                Option.ofNullable(invocation.getActionDescriptor().getAnnotation(CheckBlocked.class));

        Option<DjfsUid> uidO = checkBlockedAnnotationO
                .map(CheckBlocked::value)
                .filterMap(uidField -> invocation.getWebRequest().getParameter(uidField).firstO())
                .map(rawUid -> DjfsUid.cons(rawUid, ActionContext.CLIENT_INPUT));

        if (uidO.isPresent()) {
            DjfsUid uid = uidO.get();
            UserData user = userDao.find(uid).getOrThrow(() -> new UserNotInitializedException(uid));
            if (user.isBlocked()) {
                if (checkBlockedAnnotationO.isPresent()) {
                    throw new UserBlockedException(checkBlockedAnnotationO.get().httpStatusCode());
                }
                throw new UserBlockedException();
            }
            invocation.getWebRequest().getHttpServletRequest().setAttribute(USER_OBJ, user);
        }

        return invocation.invoke();
    }

    @Override
    public int getOrder() { return 1; }
}
