package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.ActionContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceArea;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.commune.dynproperties.DynamicProperty;

public class ClientInputDataProcessor {

    private final DynamicProperty<Long> sharedUidReplacer = new DynamicProperty<>("djfs-api-shared-uid-replacer", 883404992L);

    private final DynamicProperty<ListF<String>> invalidPathSymbols = new DynamicProperty<>("djfs-api-invalid-path-symbols", Cf.list("\u0000"));

    public DjfsUid getDjfsUidFromClientInput(String uid, String path) {
        if (!isShare(path)) {
            return DjfsUid.cons(uid, ActionContext.CLIENT_INPUT);
        }
        long sharedUid = sharedUidReplacer.get();
        return DjfsUid.consShared(sharedUid, String.valueOf(sharedUid));
    }

    public boolean isShare(String path) {
        return path.startsWith(DjfsResourcePath.DELIMITER + DjfsResourceArea.SHARE.rootFolderName + DjfsResourcePath.DELIMITER);
    }

    public boolean isValidPath(String path) {
        return !invalidPathSymbols.get().exists(path::contains);
    }

    public void validPathOrThrow(String path) {
        if (!isValidPath(path)) {
            throw new PathIsInvalidException(String.format("The path '%s' is invalid", path));
        }
    }
}
