package ru.yandex.chemodan.app.djfs.core.user;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoInviteMpfsReferralDao {
    private final MongoCollectionX<String, MongoInviteMpfsReferral> collection;

    public MongoInviteMpfsReferralDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("invite_mpfs_referrals")
                        .getCollection("invite_mpfs_referrals", BsonDocument.class),
                MongoInviteMpfsReferral.B);
    }

    public void delete(DjfsUid id) {
        collection.deleteMany(Filters.eq("_id", id.asString()));
    }

    public void deleteAll(DjfsUid ref) {
        collection.deleteMany(Filters.eq("ref", ref.asString()));
    }
}
