package ru.yandex.chemodan.app.djfs.core.user;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoInviteMpfsSentDao {
    private final MongoCollectionX<String, MongoInviteMpfsSent> collection;

    public MongoInviteMpfsSentDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("invite_mpfs_sent").getCollection("invite_mpfs_sent", BsonDocument.class),
                MongoInviteMpfsSent.B);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
