package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoOrganization {
    public static final MongoBenderParserSerializer<String, MongoOrganization> B =
            DjfsBenderFactory.createForMongo(MongoOrganization.class);

    @MongoId
    public String id;

    @BenderPart(name = "is_paid", strictName = true)
    public boolean isPaid;

    @BenderPart(name = "quota_limit", strictName = true)
    public long quotaLimit;

    @BenderPart(name = "quota_free", strictName = true)
    public long quotaFree;

    @BenderPart(name = "quota_used_by_disk", strictName = true)
    public Option<Long> quotaUsedByDisk = Option.empty();

    public Organization to() {
        return Organization.builder()
                .id(id)
                .isPaid(isPaid)
                .quotaLimit(quotaLimit)
                .quotaFree(quotaFree)
                .quotaUsedByDisk(quotaUsedByDisk.getOrElse(0L))
                .build();
    }

    public static MongoOrganization cons(Organization group) {
        MongoOrganization result = new MongoOrganization();
        result.id = group.getId();
        result.isPaid = group.isPaid();
        result.quotaLimit = group.getQuotaLimit();
        result.quotaFree = group.getQuotaFree();
        result.quotaUsedByDisk = Option.when(group.getQuotaUsedByDisk() > 0, group.getQuotaUsedByDisk());
        return result;
    }
}
