package ru.yandex.chemodan.app.djfs.core.user;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoOrganizationDao implements OrganizationDao {
    private final MongoCollectionX<String, MongoOrganization> collection;

    public MongoOrganizationDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("organizations").getCollection("organizations", BsonDocument.class),
                MongoOrganization.B);
    }

    public Option<Organization> find(String id, Option<ReadPreference> readPreference) {
        return readPreference.map(rp -> collection.findById(id, rp)).getOrElse(() -> collection.findById(id, ReadPreference.secondary()))
                .map(MongoOrganization::to);
    }

    @Override
    public Option<Organization> find(String id) {
        return find(id, Option.of(ReadPreference.secondary()));
    }

    public void insert(Organization organization) {
        collection.insertOne(MongoOrganization.cons(organization));
    }
}
