package ru.yandex.chemodan.app.djfs.core.user;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.base.AbstractInstant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoUser extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoUser> B =
            DjfsBenderFactory.createForMongo(MongoUser.class);

    @MongoId
    public String id;

    @BenderPart(name = "reg_time", strictName = true)
    public Option<Long> regTime;
    public Option<String> locale;

    @BenderPart(name = "shard_key", strictName = true)
    public int shardKey;

    public ListF<String> collections;
    public Option<String> type;
    public Option<Long> version;

    @BenderPart(name = "last_quick_move_version", strictName = true)
    public Option<Long> last_quick_move_version;

    public Option<Integer> blocked;
    public Option<DateTime> deleted;

    @BenderPart(name = "b2b_key", strictName = true)
    public Option<String> b2bKey;

    // todo: это JSON, надо типизировать
    public Option<Pdd> pdd;

    @BenderPart(name = "yateam_uid", strictName = true)
    public Option<String> yateamUid;

    public UserData toUserData() {
        return new UserData(DjfsUid.cons(id), regTime.map(InstantUtils::fromSeconds), Option.empty(), shardKey, collections,
                type.map(UserType.R::fromValue), version, last_quick_move_version, blocked.getOrElse(0) == 1, deleted.map(AbstractInstant::toInstant),
                b2bKey, false, false, yateamUid, Option.empty(), false);
    }

    public static MongoUser cons(UserData user) {
        MongoUser result = new MongoUser();
        result.id = user.getId().asString();
        // todo: check offset
        result.regTime = user.getRegTime().map(x -> (long) InstantUtils.toSeconds(x));
        result.locale = user.getLocale().map(UserLocale::value);
        result.shardKey = user.getShardKey();
        result.collections = user.getCollections();
        result.type = user.getType().map(UserType::value);
        result.version = user.getVersion();
        result.last_quick_move_version = user.getMinimumDeltaVersion();
        result.blocked = user.isBlocked() ? Option.of(1) : Option.empty();
        // todo: check offset
        result.deleted = user.getDeleted().map(x -> x.toDateTime(DateTimeZone.UTC));
        result.b2bKey = user.getB2bKey();
        result.pdd = user.getPdd();
        result.yateamUid = user.getYateamUid();
        return result;
    }
}
