package ru.yandex.chemodan.app.djfs.core.user;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.serialize.BenderSerializer;

/**
 * @author eoshch
 */
@BenderBindAllFields
@Data
public class Pdd {

    private static final BenderSerializer<Pdd> pddPgSerializer = Bender.serializer(Pdd.class);

    private static final BenderParser<Pdd> pddPgParser = Bender.parser(Pdd.class);

    public static Pdd fromJsonString(String json) {
        return pddPgParser.parseJson(json);
    }

    private final Option<String> domain;

    public String toPgJsonString() {
        return new String(pddPgSerializer.serializeJson(this));
    }
}
