package ru.yandex.chemodan.app.djfs.core.user;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;


public class PgOrganizationDao extends PgShardedDao implements OrganizationDao {
    public PgOrganizationDao(PgShardedDaoContext context) {
        super(context);
    }

    private final static RowMapper<Organization> M = (rs, rowNum) -> Organization.builder()
            .id(rs.getString("id"))
            .isPaid(rs.getBoolean("is_paid"))
            .quotaLimit(rs.getLong("quota_limit"))
            .quotaFree(rs.getLong("quota_free"))
            .quotaUsedByDisk(rs.getLong("quota_used_by_disk"))
            .build();

    @Override
    public Option<Organization> find(String id) {
        String sql = collectStats(DjfsUid.COMMON_UID) + " SELECT * FROM disk.organizations WHERE id = :id";
        return jdbcTemplate(DjfsUid.COMMON_UID).queryForOption(sql, M, Cf.map("id", id));
    }

    @Override
    public void insert(Organization organization) {
        String sql = collectStats(DjfsUid.COMMON_UID)
                + " INSERT INTO disk.organizations (id, is_paid, quota_limit, quota_free, quota_used_by_disk)"
                + " VALUES(:id, :is_paid, :quota_limit, :quota_free, :quota_used_by_disk)"
                + " ON CONFLICT (id) DO UPDATE SET quota_limit=:quota_limit, quota_free=:quota_free, quota_used_by_disk=:quota_used_by_disk, is_paid=:is_paid";

        jdbcTemplate(DjfsUid.COMMON_UID).update(
                sql, Cf.toMap(Tuple2List.fromPairs(
                        "id", organization.getId(),
                        "is_paid", organization.isPaid(),
                        "quota_limit", organization.getQuotaLimit(),
                        "quota_free", organization.getQuotaFree(),
                        "quota_used_by_disk", organization.getQuotaUsedByDisk()
                ))
        );
    }
}
