package ru.yandex.chemodan.app.djfs.core.user;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.ArrayListF;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@ActionResultPojo
@BenderBindAllFields
public class User extends DefaultObject implements DjfsUidSource {

    public DjfsUid id;
    public Option<Instant> regTime;
    public Option<UserLocale> locale;
    public int shardKey;
    public ListF<String> collections;
    public Option<UserType> type;
    public Option<Long> version;
    public Option<Long> minimumDeltaVersion;
    public boolean blocked;
    public Option<Instant> deleted;
    public Option<String> b2bKey;
    public boolean isQuickMoveUser;
    public boolean isPg;
    public Option<String> yateamUid;

    public User() {
        collections = new ArrayListF<>();
        deleted = Option.empty();
        b2bKey = Option.empty();
        yateamUid = Option.empty();
    }

    @Override
    public DjfsUid getUid() {
        return id;
    }

    public static User cons(DjfsUid uid) {
        return cons(uid, UserType.STANDARD);
    }

    public static User cons(DjfsUid uid, UserType type) {
        Instant now = Instant.now();
        User result = new User();
        result.id = uid;
        result.regTime = Option.of(now);
        result.locale = Option.of(UserLocale.RU);
        result.shardKey = 0;
        result.type = Option.of(type);
        result.version = Option.empty();
        result.minimumDeltaVersion = Option.empty();
        result.blocked = false;
        result.isQuickMoveUser = false;
        result.isPg = false;
        return result;
    }
}
