package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author alexandret
 */
public class UserBlockedException extends DjfsException implements HttpStatusCodeSource {
    private int httpStatusCode;

    public UserBlockedException() {
        httpStatusCode = HttpStatus.SC_403_FORBIDDEN;
    }

    public UserBlockedException(int statusCode) {
        httpStatusCode = statusCode;
    }

    @Override
    public int getHttpStatusCode() {
        return httpStatusCode;
    }
}

