package ru.yandex.chemodan.app.djfs.core.user;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.album.AlbumDao;
import ru.yandex.chemodan.app.djfs.core.album.AlbumFaceClustersDao;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItemDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingOrderDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingOrderHistoryDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingServiceAttributeDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingServiceAttributeHistoryDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingServiceDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingServiceHistoryDao;
import ru.yandex.chemodan.app.djfs.core.billing.BillingSubscriptionDao;
import ru.yandex.chemodan.app.djfs.core.changelog.ChangelogDao;
import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.SharpeiShardResolver;
import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoManager;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.iteration.ResourceIterator;
import ru.yandex.chemodan.app.djfs.core.lock.LockManager;
import ru.yandex.chemodan.app.djfs.core.operations.MpfsOperationHandlerContext;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.publication.LinkDataDao;
import ru.yandex.chemodan.app.djfs.core.share.GroupInviteDao;
import ru.yandex.chemodan.app.djfs.core.share.ShareManager;
import ru.yandex.chemodan.app.djfs.core.versioning.VersionManager;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author eoshch
 */
@Configuration
@Import({DjfsDbContextConfiguration.class})
public class UserContextConfiguration {
    private final DynamicProperty<Boolean> isOrganizationsInPG =
            new DynamicProperty<>("djfs.common.is-organizations-in-pg", true);

    @Bean
    public MongoInviteMpfsReferralDao mongoInviteMpfsReferralDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoInviteMpfsReferralDao(mongoClient);
    }

    @Bean
    public MongoInviteMpfsSentDao mongoInviteMpfsSentDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoInviteMpfsSentDao(mongoClient);
    }

    @Bean
    public MongoUserDao mongoUserDao(MongoShardedDaoContext dependencies) {
        return new MongoUserDao(dependencies);
    }

    @Bean
    public PgUserDao pgUserDao(PgShardedDaoContext dependencies) {
        return new PgUserDao(dependencies);
    }

    @Bean
    @Primary
    public UserDao userDaoProxy(DaoProxyFactory daoProxyFactory, MongoUserDao mongoDao, PgUserDao pgDao) {
        return daoProxyFactory.create(UserDao.class, pgDao);
    }

    @Bean
    public MongoOrganizationDao mongoOrganizationDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoOrganizationDao(mongoClient);
    }

    @Bean
    public PgOrganizationDao pgOrganizationDao(PgShardedDaoContext dependencies) {
        return new PgOrganizationDao(dependencies);
    }

    @Bean
    @Primary
    public OrganizationDao organizationDao(DaoProxyFactory daoProxyFactory, MongoOrganizationDao mongoDao, PgOrganizationDao pgDao) {
        return daoProxyFactory.create(OrganizationDao.class, pgDao, mongoDao, isOrganizationsInPG::get);
    }

    @Bean
    public UserActions userActions(UserDao dao) {
        return new UserActions(dao);
    }

    @Bean
    public UserPreliminaryDeleteOperationHandler userPreliminaryDeleteOperationHandler(
            MpfsOperationHandlerContext mpfsOperationHandlerContext, SharpeiShardResolver sharpeiShardResolver,
            ShareManager shareManager, LockManager lockManager, Blackbox2 blackbox2)
    {
        return new UserPreliminaryDeleteOperationHandler(
            mpfsOperationHandlerContext, sharpeiShardResolver, shareManager, lockManager, blackbox2);
    }

    @Bean
    public UserPermanentDeleteOperationSender userPermanentDeleteOperationSender(CeleryTaskManager celeryTaskManager,
            OperationDao operationDao)
    {
        return new UserPermanentDeleteOperationSender(celeryTaskManager, operationDao);
    }

    @Bean
    public UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler(
            MpfsOperationHandlerContext mpfsOperationHandlerContext,
            SharpeiShardResolver sharpeiShardResolver, UserDao userDao, MongoInviteMpfsReferralDao mongoInviteMpfsReferralDao,
            MongoInviteMpfsSentDao mongoInviteMpfsSentDao, AlbumDao albumDao, AlbumFaceClustersDao albumFaceClustersDao, AlbumItemDao albumItemDao,
            BillingOrderDao billingOrderDao, BillingOrderHistoryDao billingOrderHistoryDao,
            BillingServiceAttributeDao billingServiceAttributeDao,
            BillingServiceAttributeHistoryDao billingServiceAttributeHistoryDao,
            BillingServiceDao billingServiceDao, BillingServiceHistoryDao billingServiceHistoryDao,
            BillingSubscriptionDao billingSubscriptionDao, ChangelogDao changelogDao,
            Filesystem filesystem, ResourceIterator.Factory resourceIteratorFactory, LinkDataDao linkDataDao,
            ShareManager shareManager, GroupInviteDao groupInviteDao, LockManager lockManager,
            VersionManager versionManager, DiskInfoManager diskInfoManager, MpfsClient mpfsClient, Blackbox2 blackbox2)
    {
        return new UserPermanentDeleteOperationHandler(mpfsOperationHandlerContext, sharpeiShardResolver, userDao,
                mongoInviteMpfsReferralDao, mongoInviteMpfsSentDao, albumDao, albumFaceClustersDao, albumItemDao, billingOrderDao,
                billingOrderHistoryDao, billingServiceAttributeDao, billingServiceAttributeHistoryDao,
                billingServiceDao, billingServiceHistoryDao, billingSubscriptionDao, changelogDao,
                filesystem, resourceIteratorFactory, linkDataDao, shareManager, groupInviteDao, diskInfoManager,
                lockManager, versionManager, mpfsClient, blackbox2);
    }
}
