package ru.yandex.chemodan.app.djfs.core.user;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;

/**
 * @author eoshch
 */
public interface UserDao {
    @Sharded
    Option<UserData> find(DjfsUid uid);

    @Sharded
    default UserData findExistingAndNotBlocked(DjfsUid uid) {
        UserData user = find(uid).getOrThrow(() -> new UserNotInitializedException(uid));
        if (user.isBlocked()) {
            throw new UserIsBlockedException(uid);
        }
        return user;
    }

    @Sharded
    void insert(UserData user);

    @Sharded
    void changeType(DjfsUid uid, UserType type);

    @Sharded
    void incrementVersionTo(DjfsUid uid, long version);

    @Sharded
    Option<Long> incrementVersionTo_ReturnOld(DjfsUid uid, long version);

    @Sharded
    void setVersion(DjfsUid uid, long version);

    @Sharded
    void setMinimumDeltaVersion(DjfsUid uid, long version);

    @Sharded
    void setB2bKey(DjfsUid uid, String b2bKey);

    @Sharded
    void setDeleted(DjfsUid uid);

    @Sharded
    void block(DjfsUid uid);

    @Sharded
    void unblock(DjfsUid uid);

    @Sharded
    void addCollection(DjfsUid uid, String collection);

    @Sharded
    void setQuickMoveFlag(DjfsUid uid);

    @Sharded
    Option<Long> getFaceClustersVersion(DjfsUid uid);

    @Sharded
    void updateFaceClustersVersion(DjfsUid uid, long version);

    @Sharded
    void removeFaceClustersVersion(DjfsUid uid);

    @Sharded
    Tuple2<FacesIndexingState, Instant> getFacesIndexingState(DjfsUid uid);

    @Sharded
    void setFacesIndexingState(DjfsUid uid, FacesIndexingState state);
}
