package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;


public class UserIsBlockedException extends DjfsException implements HttpStatusCodeSource {
    public final DjfsUid uid;

    public UserIsBlockedException(DjfsUid uid) {
        super(uid.asString() + " is blocked");
        this.uid = uid;
    }

    public UserIsBlockedException(DjfsUid uid, String message) {
        super(uid.asString() + " is blocked: " + message);
        this.uid = uid;
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_451_UNAVAILABLE_FOR_LEGAL_REASONS;
    }
}
