package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.StringArrayEnum;
import ru.yandex.chemodan.app.djfs.core.StringArrayEnumResolver;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author eoshch
 */
public enum UserLocale implements StringArrayEnum, StringEnum {
    RU("ru", "al", "ar", "be", "by", "cz", "ee", "ge", "il", "kz", "lv", "md", "mo", "na", "us", "uz"),
    EN,
    TR,
    UK("uk", "ua"),
    ;

    // TODO: проверить, что дефолтная локаль RU: https://a.yandex-team.ru/arc/trunk/arcadia/disk/mpfs/lib/mpfs/core/user/common.py#L391
    public static final UserLocale DEFAULT_LOCALE = RU;

    private String value;
    private ListF<String> representations;

    UserLocale() {
        this.value = name().toLowerCase();
        this.representations = Cf.arrayList(this.value);
    }

    UserLocale(String value, String... alternativeRepresentations) {
        this.value = value;
        this.representations = Cf.arrayList(value).plus(Cf.arrayList(alternativeRepresentations));
    }

    @Override
    public String value() {
        return value;
    }

    @Override
    public ListF<String> representations() {
        return representations;
    }

    public static final StringArrayEnumResolver<UserLocale> R_BY_ALTERNATIVES = StringArrayEnumResolver.r(UserLocale.class);
    public static final StringEnumResolver<UserLocale> R_BY_VALUE = StringEnumResolver.r(UserLocale.class);

    public Language toLanguage() {
        switch (this) {
            case RU: return Language.RUSSIAN;
            case EN: return Language.ENGLISH;
            case TR: return Language.TURKISH;
            case UK: return Language.UKRAINIAN;
            default: throw new IllegalStateException("Can't convert " + this + " to Language");
        }
    }
}
