package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author eoshch
 */
public class UserNotInitializedException extends DjfsException implements HttpStatusCodeSource {
    public final DjfsUid uid;

    public UserNotInitializedException(DjfsUid uid) {
        super(uid.asString() + " is not initialized");
        this.uid = uid;
    }

    public UserNotInitializedException(DjfsUid uid, String message) {
        super(uid.asString() + " is not initialized: " + message);
        this.uid = uid;
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }
}
