package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.util.CeleryJobUtils;
import ru.yandex.chemodan.app.djfs.core.util.DjfsAsyncTaskUtils;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public class UserPermanentDeleteOperationSender {
    private static final Logger logger = LoggerFactory.getLogger(UserPermanentDeleteOperationSender.class);

    private final CeleryTaskManager celeryTaskManager;
    private final OperationDao operationDao;

    public UserPermanentDeleteOperationSender(CeleryTaskManager celeryTaskManager, OperationDao operationDao) {
        this.celeryTaskManager = celeryTaskManager;
        this.operationDao = operationDao;
    }

    public void send(DjfsUid uid) {
        ListF<Operation> operations = operationDao
                .find(uid, UserPermanentDeleteOperationHandler.TYPE, UserPermanentDeleteOperationHandler.SUBTYPE);

        Operation operation;
        if (operations.isEmpty()) {
            operation = Operation.cons(uid, UserPermanentDeleteOperationHandler.TYPE,
                    UserPermanentDeleteOperationHandler.SUBTYPE).withUniqueIdFromUidAndTypeAndSubtype();
            operationDao.insert(operation);
            logger.info("created UserPermanentDeleteOperation " + operation.getId() + " for " + uid.asString());
        } else {
            operation = operations.first();
            logger.info("found UserPermanentDeleteOperation " + operation.getId() + " for " + uid.asString()
                    + " state " + operation.getState());
        }

        if (!operation.isFinished()) {
            MapF<String, JsonValue> kwargs = JsonUtils.objectBuilder()
                    .add("uid", uid.asString())
                    .add("oid", operation.getId()).toMap();
            CeleryJob celeryJob = CeleryJobUtils.create(UserPermanentDeleteOperationHandler.TASK_ID,
                    DjfsAsyncTaskUtils.activeUid(uid.asString() + ":" + operation.getId()), kwargs);
            celeryTaskManager.submit(celeryJob);
        }
    }
}
