package ru.yandex.chemodan.app.djfs.core.user;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author eoshch
 */
public enum UserType implements StringEnum {
    STANDARD("standart"),
    ATTACH,
    ;

    private final String value;

    UserType() {
        this.value = name().toLowerCase();
    }

    UserType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<UserType> R = StringEnumResolver.r(UserType.class);
}
