package ru.yandex.chemodan.app.djfs.core.util;

import java.util.UUID;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.ArrayListF;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.celery.job.CeleryJobContext;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author eoshch
 */
public class CeleryJobUtils {
    public static CeleryJob create(TaskId taskId, MapF<String, JsonValue> kwargs) {
        return create(taskId, Option.empty(), Option.of(Instant.now()), kwargs);
    }

    public static CeleryJob create(TaskId taskId, DjfsUid uid, String operationId) {
        return create(taskId, Option.empty(), Option.of(Instant.now()), Cf.map(
                "uid", uid.asString(),
                "oid", operationId
                ).mapValues(JsonString::valueOf));
    }

    public static CeleryJob create(TaskId taskId, String activeUid, MapF<String, JsonValue> kwargs) {
        return create(taskId, Option.of(activeUid), Option.of(Instant.now()), kwargs);
    }

    public static CeleryJob create(TaskId taskId, String activeUid, Duration delay, MapF<String, JsonValue> kwargs) {
        return create(taskId, Option.of(activeUid), Option.of(Instant.now().plus(delay)), kwargs);
    }

    public static CeleryJob create(TaskId taskId, Option<String> activeUid, Option<Instant> scheduled,
            MapF<String, JsonValue> kwargs)
    {
        CeleryJobContext context = new CeleryJobContext(
                false,
                scheduled,
                Option.empty(),
                activeUid,
                YandexCloudRequestIdHolder.getO(),
                Option.of(HostnameUtils.localHostname()),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty()
        );

        String id = UUID.randomUUID().toString();
        return new CeleryJob(
                taskId,
                id,
                0,
                new ArrayListF<>(),
                kwargs,
                true,
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Option.of(context)
        );
    }
}
