package ru.yandex.chemodan.app.djfs.core.util;

import java.util.Map;
import java.util.concurrent.ExecutorService;

import org.slf4j.MDC;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public class ExecutorServiceUtils {
    private static final Logger errorLogger = LoggerFactory.getLogger("error");

    public static void execute(ExecutorService executorService, Runnable runnable) {
        executorService.execute(() -> {
            try {
                runnable.run();
            } catch (Exception e) {
                errorLogger.error("async execution unhandled: ", e);
                throw e;
            }
        });
    }

    public static void executeWithMdc(ExecutorService executorService, Runnable runnable) {
        Map current = MDC.getCopyOfContextMap();
        execute(executorService, () -> {
            Map previous = MDC.getCopyOfContextMap();
            MDC.setContextMap(current);
            try {
                runnable.run();
            } finally {
                MDC.setContextMap(previous);
            }
        });
    }
}
