package ru.yandex.chemodan.app.djfs.core.util;

import org.joda.time.Instant;

/**
 * @author eoshch
 */
public final class InstantUtils {
    public static Instant fromSeconds(int seconds) {
        return fromSeconds((long) seconds);
    }

    public static Instant fromSeconds(long seconds) {
        return new Instant(seconds * 1000);
    }

    public static Instant fromSeconds(double seconds) {
        return fromSeconds((long) seconds);
    }

    public static Instant fromSeconds(String seconds) {
        return new Instant(Long.parseLong(seconds) * 1000);
    }

    public static int toSeconds(Instant instant) {
        return Math.toIntExact(toSecondsLong(instant));
    }

    public static long toSecondsLong(Instant instant) {
        return toSecondsHalfUp(instant);
    }

    public static long toSecondsHalfDown(Instant instant) {
        long millis = instant.getMillis();
        return (millis + (millis >= 0 ? 499 : -500)) / 1000;
    }

    public static long toVersion(Instant instant) {
        return instant.getMillis() * 1000;
    }

    public static long currentVersion() {
        return toVersion(Instant.now());
    }

    private static long toSecondsHalfUp(Instant instant) {
        long millis = instant.getMillis();
        return (millis + (millis >= 0 ? 500 : -500)) / 1000;
    }
}
